package com.tyro.tyroclientsample

import android.os.Bundle
import android.support.v7.app.AppCompatActivity
import android.view.Menu
import android.view.MenuItem
import android.webkit.WebView
import com.tyro.androidtta.*

import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity() {

    private lateinit var tyroClient: TyroClient

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        setSupportActionBar(toolbar)
        val webView: WebView = findViewById(R.id.iclient_view)
        tyroClient = TyroClient(webView,
                "someApiKey",
                PosProductData("ACME", "POS", "1.0.0"),
                IclientSource.SIMULATOR)

        purchaseButton.setOnClickListener {
            val parameters = mutableMapOf<String, Any>()
            parameters["amount"] = "10000"
            parameters["integratedReceipt"] = true

            tyroClient.performOperation(
                    "purchase",
                    parameters,
                    { receipt -> println("receipt = [$receipt]") },
                    { data -> println("data = [$data]") })
        }
    }

    override fun onCreateOptionsMenu(menu: Menu): Boolean {
        // Inflate the menu; this adds items to the action bar if it is present.
        menuInflater.inflate(R.menu.menu_main, menu)
        return true
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        return when (item.itemId) {
            R.id.action_settings -> { tyroClient.pairTerminal(); true }
            else -> super.onOptionsItemSelected(item)
        }
    }
}
