//
//  ConfigureScreen.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble
import XCTest

class ConfigureScreen: Screen {

    private static var lastMid : String? = nil
    private static var lastTid : String? = nil
    
    override class func isDisplayed() -> Bool {
        return app.navigationBars["Configure POS"].exists
    }
    
    func iKnowWhatIamDoing() -> ConfigureScreen {
        if (app.staticTexts["I know what I'm doing"].exists) {
            app.staticTexts["I know what I'm doing"].tap()
        }
        Thread.sleep(forTimeInterval: 3)
        return self
    }
    
    func xenta() -> ConfigureScreen {
        if (app.staticTexts["Help"].exists) {
            app.staticTexts["Help"].tap()
        }
        
        expect(self.app.images["Xenta"].exists).toEventually(beTrue(), timeout: 10)
        
        app.images["Xenta"].tap()
        expect(self.app.staticTexts["Next"].exists).toEventually(beTrue(), timeout: 10)
        
        app.staticTexts["Next"].tap()
        return self
    }

    func enterMid(_ mid: String) -> ConfigureScreen {
        let midTextField: XCUIElement = app.textFields["Enter MID shown on terminal..."]
        waitUntilExistsAndHittable(element: midTextField)
        enter(text: mid, in: midTextField)
        return self
    }

    func enterTid(_ tid: String) -> ConfigureScreen {
        let tidTextField: XCUIElement = app.textFields["Enter TID shown on terminal..."]
        waitUntilExistsAndHittable(element: tidTextField)
        enter(text: tid, in: tidTextField)
        return self
    }

    private func verifyMidAndTidWasEntered(mid: String, midField: XCUIElement, tid: String, tidField: XCUIElement) -> Bool {
        if midField.value as? String == mid && tidField.value as? String == tid {
            return true
        }
    
        ConfigureScreen.lastMid = nil
        ConfigureScreen.lastTid = nil
        return false
    
    }
    
    private func enter(text: String, in field: XCUIElement) {
        if let stringValue = field.value as? String, field.elementType == XCUIElement.ElementType.textField  {
            if stringValue == text {
                print("################## values match ############################")
                return
            }
        }
        field.clear()
        field.setTextSafely(text)
    }
    
    func authorise() -> ConfigureScreen {
        press(with: "Authorise")
        return self
    }
    
    func ok() -> ConfigureScreen {
        tap(with: "Ok")
        return self
    }
    
    func baseUrl(_ baseUrl: String) -> ConfigureScreen {
        expect(self.app.textFields["baseUrl"].exists).toEventually(beTrue(), timeout: 10)
        
        
        let baseurlTextField = app.textFields["baseUrl"]
        enter(text: baseUrl, in: baseurlTextField)
        _ = refreshScreen()

        Thread.sleep(forTimeInterval: 3)
        return self
    }
    
    func integratedReciept(_ useIntegratedReceipt: Bool) -> ConfigureScreen {
        if (useIntegratedReceipt) {
            expect(self.app.switches["integratedReceiptSwitch"].exists).toEventually(beTrue(), timeout: 10)
            app.switches["integratedReceiptSwitch"].tap()
        }
        return self
    }

    func refreshScreen() -> ConfigureScreen {
        tap(with: "refreshScreen")
        return self
    }
}
