//
//  HealthPointClaimTest.swift
//  PosSimulator
//
//  Created by development on 12/22/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class HealthPointClaimTest: TestBase {

    func testHealthPointClaim() {
        configurePos()
        let healthPointScreen = healthPoint().initiateClaim("10100")

        expect(healthPointScreen.app.staticTexts["Claim assessed. Gap $0.00"].exists).toEventually(beTrue())

        _ = healthPointScreen.accept()

        expect(healthPointScreen.app.staticTexts["Result: APPROVED"].exists).toEventually(beTrue())
    }
    
    func testCancelHealthPointClaim() {
        configurePos()
        let healthPointScreen = healthPoint()
            .cancelClaim(claimAmount: "5702", withReferenceTag: "123456")
        
        app.buttons["\u{e020} Cancel Transaction"].tap()
        
        expect(healthPointScreen.app.staticTexts["Are you sure you want to cancel?"].exists).toEventually(beTrue())
        
        _ = healthPointScreen.yes()
        
        expect(healthPointScreen.app.staticTexts["Result: CANCELLED"].exists).toEventually(beTrue())
        
    }
}
