//
//  MedicareClaimTest.swift
//  PosSimulator
//
//  Created by development on 12/22/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class MedicareClaimTest: TestBase {

    func testBulkBillFullyPaidAndPartPaidClaim() {
        
        configurePos()
        var screen = medicare().bulkBillClaim()
        expect(self.app.staticTexts["Result: APPROVED"].exists).toEventually(beTrue())
        
        screen = screen.fullyPaidClaim(amount: "10100")
        expect(self.app.staticTexts["Result: APPROVED"].exists).toEventually(beTrue())
        
        _ = screen.partPaidClaim(amount: "10100", contribution: "100")
        expect(self.app.staticTexts["CLAIM APPROVED. Print patient copy?"].exists).toEventually(beTrue())
        app.buttons["NO"].tap()
        expect(self.app.staticTexts["Result: APPROVED"].exists).toEventually(beTrue())
    }
}
