//
//  OpenTabTest.swift
//  PosSimulator
//
//  Created by development on 12/22/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class OpenTabTest: TestBase {
    
    func testOpenTab() {
        configurePos()
        performOpenTab()
    }
    
    func testOpenTabWithIntegratedReciept() {
        configurePos(andIntegratedReceipt: true)
        performOpenTab(expectCustomerCopy: true, expectMerchantCopy: true)
    }
    
    func performOpenTab(expectApproved: Bool = true, expectCustomerCopy: Bool = false, expectMerchantCopy: Bool = false) {
            let paymentsScreen = payments()
                .openTabAmount("10200")
                .openTab()
            
            if (!expectCustomerCopy) {
                expect(paymentsScreen.app.staticTexts["APPROVED. Print customer copy?"].exists).toEventually(beTrue())
                _ = paymentsScreen.no()
            }
            
            expect(paymentsScreen.app.staticTexts["APPROVED"].exists).toEventually(equal(expectApproved))
            expect((paymentsScreen.app.textViews["customerReceipt"].value as? String)?.containsString("CUSTOMER COPY")).toEventually(equal(expectCustomerCopy))
            expect((paymentsScreen.app.textViews["merchantReceipt"].value as? String)?.containsString("MERCHANT COPY")).toEventually(equal(expectMerchantCopy))
    }
    
    func testCloseTab() {
        configurePos(andIntegratedReceipt: true)
        let paymentsScreen = payments()
            .openTabAmount("10200")
            .openTab()
        
        expect(paymentsScreen.app.staticTexts["APPROVED"].exists).toEventually(equal(true))
        expect((paymentsScreen.app.textViews["customerReceipt"].value as? String)).toEventually(contain("CUSTOMER COPY"))
        expect((paymentsScreen.app.textViews["merchantReceipt"].value as? String)).toEventually(contain("MERCHANT COPY"))
        
        var completionReference = paymentsScreen.app.textViews["merchantReceipt"].value as! String
        completionReference = completionReference.components(separatedBy: "Completion Ref: ")[1]
        completionReference = completionReference.components(separatedBy: "\n")[0]
        
        _ = paymentsScreen
            .closeTabAmount("10200", andCompletionReference: completionReference)
            .closeTab()
        
        expect(self.app.alerts["Close Tab"].exists).toEventually(beTrue())
        expect(self.app.alerts["Close Tab"].staticTexts["Close tab request accepted"].exists).to(beTrue())
        
        self.app.alerts["Close Tab"].buttons["OK"].tap()
    }
    
    func testVoidTab() {
        configurePos(andIntegratedReceipt: true)
        let paymentsScreen = payments()
            .openTabAmount("10200")
            .openTab()
        
        expect(paymentsScreen.app.staticTexts["APPROVED"].exists).toEventually(equal(true), timeout: 10)
        expect((paymentsScreen.app.textViews["customerReceipt"].value as? String)).toEventually(contain("CUSTOMER COPY"))
        expect((paymentsScreen.app.textViews["merchantReceipt"].value as? String)).toEventually(contain("MERCHANT COPY"))
        
        var completionReference = paymentsScreen.app.textViews["merchantReceipt"].value as! String
        completionReference = completionReference.components(separatedBy: "Completion Ref: ")[1]
        completionReference = completionReference.components(separatedBy: "\n")[0]
        
        _ = paymentsScreen
            .voidTabReference(completionReference)
            .voidTab()
        
        expect(self.app.alerts["Close Tab"].exists).toEventually(beTrue(), timeout: 10)
        expect(self.app.alerts["Close Tab"].staticTexts["Void tab request accepted"].exists).to(beTrue())
        
        app.alerts["Close Tab"].buttons["OK"].tap()
    }
    
    
}
