//
//  PairPosTest.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class PairPosTest: TestBase {
    
    func testPairPosWithTerminal() {
        let configScreen = configure()
            .iKnowWhatIamDoing()
            .enterMid("123")
            .enterTid("111")
            .authorise()
        
        expect(configScreen.app.staticTexts["Pairing successful."].exists).toEventually(beTrue())
        
        _ = configScreen.ok()
    }
    
    func testPairPosWithXentaTerminal() {
        
        let configScreen = configure()
            .xenta()
            .enterMid("123")
            .enterTid("111")
            .authorise()

        expect(configScreen.app.staticTexts["Pairing successful."].exists).toEventually(beTrue())
        
        _ = configScreen.ok()
        
    }
}

