//
//  PaymentsScreen.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class PaymentsScreen: Screen {
    
    override class func isDisplayed() -> Bool {
        return app.navigationBars["Tyro Pos Simulator"].exists
    }
    
    func purchaseAmount(_ amount: String) -> PaymentsScreen {
        return setAmountForFieldName("amount", amount: amount)
    }
    
    func cashOutAmount(_ amount: String) -> PaymentsScreen {
        return setAmountForFieldName("Cash out amount", amount: amount)
    }
    
    func openTabAmount(_ amount: String) -> PaymentsScreen {
        return setAmountForFieldName("openTabAmount", amount: amount)
    }
    
    func refundAmount(_ amount: String) -> PaymentsScreen {
        return setAmountForFieldName("refundAmount", amount: amount)
    }

    func closeTabAmount(_ amount: String, andCompletionReference completionReference: String) -> PaymentsScreen{
        return setAmountForFieldName("closeTabAmount", amount: amount).setAmountForFieldName("closeTabCompletionReference", amount: completionReference)
    }
    
    func voidTabReference(_ completionReference: String) -> PaymentsScreen {
        return setAmountForFieldName("voidTabCompletionReference", amount: completionReference)
    }
    
    func initiatePurchase() -> PaymentsScreen {
        tap(with: "Initiate Purchase")
        return self
    }
    
    func openTab() -> PaymentsScreen {
        tap(with: "Open Tab")
        return self
    }
    
    func closeTab() -> PaymentsScreen {
        tap(with: "Close Tab")
        return self
    }
    
    func voidTab() -> PaymentsScreen {
        tap(with: "Void Tab")
        return self
    }
    
    func refund() -> PaymentsScreen {
        press(with: "Initiate Refund")
        return self
    }
    
    func yes() -> PaymentsScreen {
        tap(with: "YES")
        return self
    }
    
    func no() -> PaymentsScreen {
        tap(with: "NO")
        return self
    }
    
    func continueLastTransaction() -> PaymentsScreen {
        tap(with: "Continue last transaction")
        return self
    }
    
    internal func setAmountForFieldName(_ fieldName: String, amount: String) -> PaymentsScreen {
        expect(self.app.textFields[fieldName].exists).toEventually(beTrue(), timeout: 10)
        let amountField = app.textFields[fieldName]
        if (amountField.value as? String != amount) {
            amountField.clear()
            amountField.setTextSafely(amount)
        }
        
        return self
    }
}
