//
//  ReportsScreen.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation

class ReportsScreen: Screen {
    
    override class func isDisplayed() -> Bool {
        return app.navigationBars["Reports"].exists
    }
    
    func enterHealthPointDate(_ date: String) -> ReportsScreen {
            return setValueForFieldName("healthPointReportDate", value: date) as! ReportsScreen
    }
    
    func enterPaymentsDate(_ date: String) -> ReportsScreen {
        return setValueForFieldName("paymentReportDate", value: date) as! ReportsScreen
    }
    
    func tapPayments() -> ReportsScreen {
        tap(with: "payments")
        return self
    }
    
    func tapClaims() -> ReportsScreen {
        tap(with: "Claims")
        return self
    }
    
    func tapDetails() -> ReportsScreen {
        tap(with: "Detail")
        return self
    }
    
    func tapSummary() -> ReportsScreen {
        tap(with: "Summary")
        return self
    }
    
    func tapManuallySettleTerminal() -> ReportsScreen {
        press(with: "Manually settle terminal")
        return self
    }
}
