//
//  HealthPointReconciliationReportTest.swift
//  PosSimulator
//
//  Created by development on 12/22/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class ReportsTest: TestBase {
    
    func testHealthPointPaymentsReconciliationReport() {
        let reportsScreen = reports()
            .enterHealthPointDate("20140829")
            .tapPayments()
        expect(reportsScreen.app.staticTexts["Result: success"].exists).toEventually(beTrue())
        _ = expect(reportsScreen.app.staticTexts["<payments-reconciliation-report/>"].exists)
    }
    
    func testHealthPointClaimsReconciliationReport() {
        let reportsScreen = reports()
            .enterHealthPointDate("20140829")
            .tapClaims()
        expect(reportsScreen.app.staticTexts["Result: success"].exists).toEventually(beTrue())
        _ = expect(reportsScreen.app.staticTexts["<claims-reconciliation-report/>"].exists)
    }

    func testPaymentSummaryReport() {
        configurePos(andMid: "200", andTid: "200")
        let reportsScreen = reports()
            .enterPaymentsDate(today)
            .tapSummary()
        expect(reportsScreen.app.staticTexts["Result: success"].exists).toEventually(beTrue())
        _ = expect(reportsScreen.app.staticTexts["SUMMARY REPORT"].exists)
    }
    
    func testPaymentDetailReport() {
        configurePos(andMid: "200", andTid: "200")
        let reportsScreen = reports()
            .enterPaymentsDate(today)
            .tapDetails()
        expect(reportsScreen.app.staticTexts["Result: success"].exists).toEventually(beTrue())
        _ = expect(reportsScreen.app.staticTexts["DETAIL REPORT"].exists)
    }
    
    func testManuallySettleTerminal() {
        configurePos(andMid: "200", andTid: "200")
        let reportsScreen = reports()
            .tapManuallySettleTerminal()
        expect(reportsScreen.app.staticTexts["Result: success"].exists).toEventually(beTrue())
        _ = expect(reportsScreen.app.staticTexts["Settlement complete"].exists)

    }
    
    internal var today: String {
        get {
            let formatter = DateFormatter()
            formatter.dateFormat = "yyyyMMdd"
            
            return formatter.string(from: Date())
        }
    }
}
