//
//  Screen.swift
//  PosSimulator
//
//  Created by development on 21/12/15.
//  Copyright © 2015 Tyro Payments. All rights reserved.
//

import Foundation
import XCTest
import Nimble

class Screen {
    
    class var app: XCUIApplication { get { return TestBase.app } }
    var app: XCUIApplication { get { return TestBase.app } }
    
    required init() {
        expect(self.isDisplayed()).toEventually(beTrue(), timeout: 30, description: "Screen \(type(of: self)) not displayed")
        if (!isDisplayed()) {
            print("\(self) was not displayed")
        }
    }

    class func isDisplayed() -> Bool {
        fail("isDisplayed is not overridden")
        return false
    }
    
    final func isDisplayed() -> Bool {
        return type(of: self).isDisplayed()
    }
    
    
    func tap(with buttonName: String) {
        waitUntilExistsAndHittable(element: self.app.buttons[buttonName], timeout: 30)
        app.buttons[buttonName].tap()
    }
    
    func press(with buttonName: String) {
        waitUntilExistsAndHittable(element: self.app.buttons[buttonName], timeout: 30)
        app.buttons[buttonName].press(forDuration: 0.1);
    }
    
    func waitUntilExistsAndHittable(element: XCUIElement, timeout: TimeInterval = 5) {
        expect(element.exists).toEventually(beTrue(), timeout: timeout)
        expect(element.isHittable).toEventually(beTrue(), timeout: timeout)
    }
    
    func setValueForFieldName(_ fieldName: String, value: String) -> Screen {
        let field = XCUIApplication().textFields[fieldName]
        field.clear()
        field.setTextSafely(value)
        return self
    }
}
