//
//  HealthPointScreen.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation


class HealthPointScreen: Screen {
    
    override class func isDisplayed() -> Bool {
        return app.navigationBars["HealthPoint"].exists
    }
    
    func initiateClaim(_ amount: String) -> HealthPointScreen {
        return (setValueForFieldName("claimAmount", value: amount) as! HealthPointScreen).initiateClaim()
    }
    
    func initiateClaim() -> HealthPointScreen {
        tap(with: "Initiate Claim")
        return self
    }
    
    func cancelClaim() -> HealthPointScreen {
        tap(with: "Cancel Claim")
        return self
    }
    
    func accept() -> HealthPointScreen {
        tap(with: "ACCEPT")
        return self
    }

    func yes() -> HealthPointScreen {
        tap(with: "YES")
        return self
    }
    
    func cancelClaim(claimAmount amount: String, withReferenceTag tag: String) -> HealthPointScreen {
        return ((setValueForFieldName("claimAmount", value: amount) as! HealthPointScreen)
            .setValueForFieldName("Ref Tag", value: tag) as! HealthPointScreen)
            .cancelClaim()
    }
}
