//
//  MedicareScreen.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation

class MedicareScreen: Screen {
    
    override class func isDisplayed() -> Bool {
        return app.navigationBars["Medicare"].exists
    }
    
    func fullyPaidClaim(amount: String) -> MedicareScreen {
        _ = setValueForFieldName("fullyPaidClaimAmount", value: amount)
        tap(with: "Fully Paid Claim")
        return self
    }
    
    func partPaidClaim(amount: String, contribution: String) -> MedicareScreen {
        _ = setValueForFieldName("partPaidClaimAmount", value: amount)
        _ = setValueForFieldName("partPaidContributionAmount", value: contribution)
        tap(with: "Part Paid Claim")
        return self
    }
    
    func bulkBillClaim() -> MedicareScreen {
        tap(with: "Bulk Bill Claim")
        return self
    }
}
