//
//  TestBase.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import XCTest
import Nimble

extension XCUIElement {

    func setTextSafely(_ text: String) {
        self.tap()
        Thread.sleep(forTimeInterval: 1)
        self.typeText(text)
    }
    
    func clear() {
        if let stringValue = self.value as? String, self.elementType == XCUIElement.ElementType.textField  {
            let deleteString = String(repeating: XCUIKeyboardKey.delete.rawValue, count: stringValue.count)
            self.setTextSafely(deleteString)
        } else if self.elementType == XCUIElement.ElementType.textField {
            self.tap()
            self.doubleTap()
            
            
            if TestBase.app.menuItems["Select All"].exists {
                TestBase.app.menuItems["Select All"].tap()
            }
            let deleteString = String(repeating: XCUIKeyboardKey.delete.rawValue, count: 20)
            self.typeText(deleteString)
        }
    }

    func clearText() {
        guard let stringValue = self.value as? String, self.elementType == XCUIElement.ElementType.textField else {
            XCTFail("You are trying to clear an element that is not a text field!")
            return
        }
        let deleteString = String(repeating: XCUIKeyboardKey.delete.rawValue, count: stringValue.count)
        self.setTextSafely(deleteString)
    }

    func scrollToElement() {
        while !self.visible() {
            swipeUp()
        }
    }
    
    func visible() -> Bool {
        guard self.exists && !self.frame.isEmpty else { return false }
        return XCUIApplication().windows.element(boundBy: 0).frame.contains(self.frame)
    }
}

let DEFAULT_URL = "http://localhost:8888"

class TestBase: XCTestCase {
    
    static var useIntegratedReciept: Bool? = nil
    
    static var app = XCUIApplication()
    internal var app: XCUIApplication { get { return TestBase.app } }
    
    override func setUp() {
        app.launchArguments = ["enable-testing"]
        app.launch()
        Nimble.AsyncDefaults.Timeout = 10
        Nimble.AsyncDefaults.PollInterval = 0.1
    }
    
    override func tearDown() {
        app.terminate()
        super.tearDown()
    }
    
    func payments() -> PaymentsScreen {
        tapTabBar(with: "Payments")
        return PaymentsScreen()
    }
    
    func configure() -> ConfigureScreen {
        tapTabBar(with: "Configure")
        expect(self.app.webViews.staticTexts["  Configuration"].exists).toEventually(beTrue(), timeout: 3)
        
        //Hack to get around not being able to clear localStorage for the WKWebView
        app.buttons["refreshScreen"].tap()
        Thread.sleep(forTimeInterval: 3)
        
        return ConfigureScreen()
    }
    
    func healthPoint() -> HealthPointScreen {
        tapTabBar(with: "HealthPoint")
        return HealthPointScreen()
    }
    
    func reports() -> ReportsScreen {
        tapTabBar(with: "Reports")
        return ReportsScreen()
    }
    
    func uploadLogs() -> UploadLogsScreen {
        tapTabBar(with: "Upload Logs")
        return UploadLogsScreen()
    }
    
    func medicare() -> MedicareScreen {
        tapTabBar(with: "Medicare")
        return MedicareScreen()
    }
    
    func configurePos(baseUrl: String = DEFAULT_URL, andIntegratedReceipt useIntegratedReciept:Bool = false, andMid mid: String = "123", andTid tid: String = "111") {
        if (useIntegratedReciept != TestBase.useIntegratedReciept) {
            _ = configure()
                .baseUrl(baseUrl)
                .integratedReciept(useIntegratedReciept)
                .iKnowWhatIamDoing()
                .enterMid(mid)
                .enterTid(tid)
                .authorise()
                .ok()
            TestBase.useIntegratedReciept = useIntegratedReciept
        }
        _ = payments()
    }
    
    func tapTabBar(with buttonName: String) {
        expect(self.app.tabBars.buttons[buttonName].exists).toEventually(beTrue(), timeout: 30)
        expect(self.app.tabBars.buttons[buttonName].isHittable).toEventually(beTrue(), timeout: 30)
        
        app.tabBars.buttons[buttonName].tap()
    }
}

extension String {
    func containsString(_ subString : String) -> Bool {
        if self.range(of: subString) != nil {
            return true
        }
        return false
    }
}
