//
//  UploadLogsTest.swift
//  PosSimulator
//
//  Created by development on 12/22/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class UploadLogsTest: TestBase {

    func testUploadLogs() {
        let originalStaticTextsCount = app.staticTexts.count
        let uploadLogsScreen = uploadLogs()
            .displayData()
        
        // We can't seem to get the actual text from all the static texts, so we just check that a whole bunch were added
        expect(originalStaticTextsCount) < Int(truncating: NSNumber(value: app.staticTexts.count + 10))
        Thread.sleep(forTimeInterval: 1)
            
        _ = uploadLogsScreen
            .sendToTyro()

        expect(uploadLogsScreen.app.staticTexts["Upload successful - thank you."].exists).toEventually(beTrue(), timeout: 5)
    }
}
