//
//  WebViewErrorTest.swift
//  PosSimulator
//
//  Created by development on 12/21/15.
//  Copyright © 2015 Tyro Payment Limited. All rights reserved.
//

import Foundation
import Nimble

class WebViewErrorTest: TestBase {
    
    func testJavascriptErrorWhenInitiatingPurchase() {
        let paymentsScreen = payments()
            .purchaseAmount("error")
            .initiatePurchase()
        
        expect(self.app.alerts["Error"].exists).toEventually(beTrue())
        expect(self.app.alerts["Error"].staticTexts["SYSTEM ERROR"].exists).to(beTrue())
        
        tapErrorAlertButton(with: "OK")
        
        expect(paymentsScreen.app.staticTexts["APPROVED. Print customer copy?"].exists).toEventually(beFalse())
    }

    func testErrorWhenLoadingConfigurePosWebView() {
        _ = configure()
            .baseUrl("invalidUrl")

        tapErrorAlertButton(with: "Ok")
    }
    
    func testErrorWhenLoadingTransactionWebView() {
        testErrorWhenLoadingConfigurePosWebView()
        _ = payments()
            .initiatePurchase()
        
        expect(self.app.alerts["Error"].exists).toEventually(beTrue(), timeout: 10)
        expect(self.app.alerts["Error"].staticTexts["Failed to start transaction"].exists).to(beTrue())
        
        tapErrorAlertButton(with: "OK")
        
    }
    
    func tapErrorAlertButton(with buttonName: String) {
        expect(self.app.alerts["Error"].buttons[buttonName].exists).toEventually(beTrue(), timeout: 10)
        expect(self.app.alerts["Error"].buttons[buttonName].isHittable).toEventually(beTrue(), timeout: 10)
        app.alerts["Error"].buttons[buttonName].tap()
    }
}
