/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Random;
import java.util.TimeZone;
import net.moneyswitch.Configuration;
import net.moneyswitch.DccTransactionCommand$AjcClosure1;
import net.moneyswitch.HttpContextFactory;
import net.moneyswitch.MacService;
import net.moneyswitch.ReceiptBlockBuilder;
import net.moneyswitch.RequestAndResponseLoggingAspect;
import net.moneyswitch.UnsuccessfulRequestException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class DccTransactionCommand {
    private final Configuration config;
    private final String amountInAUD;
    private final String posReference;
    private final String tableNumber;
    private final String operatorId;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DccTransactionCommand(Configuration config, String amountInAUD, String posReference, String tableNumber, String operatorId) {
        this.config = config;
        this.amountInAUD = amountInAUD;
        this.posReference = posReference;
        this.tableNumber = tableNumber;
        this.operatorId = operatorId;
    }

    public void execute() throws UnsuccessfulRequestException, IOException, JSONException {
        String elidedPan = "XXXXXXXXXXXX9999";
        String transactionReference = Integer.toString(new Random().nextInt(999999) + 1);
        DateTime terminalTransactionDateTime = new DateTime().withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone("Australia/Sydney")));
        String responseMessage = "APPROVED";
        String responseCode = "00";
        String cardType = "Visa";
        String transactionCurrency = "USD";
        String exchangeRate = "1.07";
        String amountInUSD = new BigDecimal(this.amountInAUD).multiply(new BigDecimal(exchangeRate)).setScale(2, RoundingMode.HALF_UP).toPlainString();
        JSONObject transactionResult = new JSONObject().put("result", (Object)"APPROVED").put("table", (Object)this.tableNumber).put("approval-code", (Object)responseCode).put("mid", (Object)this.config.getMid()).put("tid", (Object)this.config.getTid()).put("pos-reference", (Object)this.posReference).put("issuer-action-code", (Object)"00").put("response-message", (Object)responseMessage).put("tip-amount", (Object)"0").put("base-amount", (Object)this.amountInAUD).put("base-currency", (Object)"AUD").put("card-currency", (Object)transactionCurrency).put("card-type", (Object)cardType).put("elided-pan", (Object)elidedPan).put("operator-id", (Object)this.operatorId).put("pan-length", (Object)"16").put("rrn", (Object)"899768062957").put("terminal-transaction-local-date-time", (Object)terminalTransactionDateTime.toString("yyyyMMddHHmmssZ")).put("transaction-reference", (Object)transactionReference).put("transaction-type", (Object)"purchase").put("transmission-date-time", (Object)new DateTime().withZone(DateTimeZone.UTC).toString("yyyyMMddHHmmssZ")).put("transaction-amount", (Object)amountInUSD).put("transaction-currency", (Object)transactionCurrency).put("exchange-rate", (Object)exchangeRate).put("receipt-block", (Object)new ReceiptBlockBuilder(this.config.getTid(), elidedPan, cardType, this.amountInAUD, null, transactionReference, terminalTransactionDateTime, responseMessage, responseCode, this.tableNumber).withDccInfo(amountInUSD, exchangeRate).build());
        String json = transactionResult.toString();
        HttpPost request = new HttpPost(this.config.getTransactionResultUrl());
        StringEntity transactionEntity = new StringEntity(json, ContentType.TEXT_PLAIN);
        request.setHeader((Header)new BasicHeader("x-tyro-mac", MacService.calculateMac(json, this.config)));
        request.setEntity((HttpEntity)transactionEntity);
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpContext httpContext = HttpContextFactory.newContext(this.config);
        HttpPost httpPost = request;
        CloseableHttpClient closeableHttpClient = client;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)closeableHttpClient, (Object)httpPost, (Object)httpContext);
        Object[] objectArray = new Object[]{this, closeableHttpClient, httpPost, httpContext, joinPoint};
        HttpResponse response = RequestAndResponseLoggingAspect.aspectOf().logRequestsAndResponses(new DccTransactionCommand$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112), (HttpUriRequest)httpPost);
        StatusLine statusLine = response.getStatusLine();
        if (statusLine.getStatusCode() != 200) {
            throw new UnsuccessfulRequestException(statusLine, null);
        }
    }

    static {
        DccTransactionCommand.ajc$preClinit();
    }

    static final /* synthetic */ HttpResponse execute_aroundBody0(DccTransactionCommand dccTransactionCommand, HttpClient httpClient, HttpUriRequest httpUriRequest, HttpContext httpContext, JoinPoint joinPoint) {
        return httpClient.execute(httpUriRequest, httpContext);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DccTransactionCommand.java", DccTransactionCommand.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "execute", "org.apache.http.client.HttpClient", "org.apache.http.client.methods.HttpUriRequest:org.apache.http.protocol.HttpContext", "arg0:arg1", "java.io.IOException:org.apache.http.client.ClientProtocolException", "org.apache.http.HttpResponse"), 93);
    }
}

