/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.moneyswitch.BadMacException;
import net.moneyswitch.Configuration;
import org.apache.commons.codec.binary.Hex;

public final class MacService {
    private MacService() {
    }

    public static String calculateMac(String json, Configuration config) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA1");
            SecretKeySpec secret = new SecretKeySpec(config.getPassphrase().getBytes("ISO-8859-1"), "HmacSHA1");
            hmac.init(secret);
            byte[] macBytes = hmac.doFinal(json.getBytes("ISO-8859-1"));
            return new String(Hex.encodeHex(macBytes, false));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void verifyMac(String content, Configuration config, String providedMac) throws BadMacException {
        String calculatedMac = MacService.calculateMac(content, config);
        if (!calculatedMac.equalsIgnoreCase(providedMac)) {
            throw new BadMacException(providedMac, calculatedMac, content);
        }
    }
}

