/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import net.moneyswitch.AlwaysReturnOutcomeFlagException;
import net.moneyswitch.BadMacException;
import net.moneyswitch.BadResponseContentException;
import net.moneyswitch.Configuration;
import net.moneyswitch.DccTransactionCommand;
import net.moneyswitch.DiagnosticsCommand;
import net.moneyswitch.OpenSale;
import net.moneyswitch.OpenSalesCommand;
import net.moneyswitch.TransactionCommand;
import net.moneyswitch.UnexpectedResponseToBadMac;
import net.moneyswitch.UnsuccessfulRequestException;
import net.moneyswitch.console.Console;
import net.moneyswitch.console.IntellijConsole;
import net.moneyswitch.console.JavaIoConsole;
import org.apache.commons.lang.StringUtils;

public class MobileIntegrationTerminalMessageSimulator {
    private static boolean useValidMac = true;

    public static void main(String[] args) {
        Console console = MobileIntegrationTerminalMessageSimulator.getConsole();
        PrintWriter consoleWriter = console.getWriter();
        MobileIntegrationTerminalMessageSimulator.showIntroduction(consoleWriter);
        Properties props = new Properties();
        try {
            props.load(new FileInputStream("tyro_mobile_integration_simulator.properties"));
        }
        catch (IOException e) {
            consoleWriter.append("\nError loading tyro_mobile_integration_simulator.properties file - reason: ").append(e.getMessage()).append("\n");
            consoleWriter.flush();
            System.exit(1);
        }
        String mid = props.getProperty("tyro.merchant.id").trim();
        String tid = props.getProperty("tyro.terminal.id").trim();
        String passPhrase = props.getProperty("message.authentication.passphrase").trim();
        String openSalesUrl = props.getProperty("pos.open.sales.url").trim();
        String transactionResultUrl = props.getProperty("pos.transaction.result.url").trim();
        String diagnosticsUrl = props.getProperty("pos.diagnostics.url").trim();
        String alwaysReturnOutcome = props.getProperty("always.return.outcome").trim();
        if (StringUtils.isBlank((String)mid) || StringUtils.isBlank((String)tid) || StringUtils.isBlank((String)passPhrase) || StringUtils.isBlank((String)openSalesUrl) || StringUtils.isBlank((String)transactionResultUrl) || StringUtils.isBlank((String)diagnosticsUrl) || StringUtils.isBlank((String)alwaysReturnOutcome)) {
            consoleWriter.append("\nCould not read properties from file - check that all properties in tyro_mobile_integration_simulator.properties file have valid values\n");
            consoleWriter.flush();
            System.exit(1);
        }
        Configuration config = new Configuration(mid, tid, passPhrase, openSalesUrl, transactionResultUrl, diagnosticsUrl, Boolean.parseBoolean(alwaysReturnOutcome));
        MobileIntegrationTerminalMessageSimulator.readHttpBasicAuthCredentials(config, props);
        MobileIntegrationTerminalMessageSimulator.showActions(consoleWriter);
        while (true) {
            block65: {
                String tableNumber;
                String operatorId;
                String selectedCommand = console.readLine();
                consoleWriter.println();
                if ("1".equals(selectedCommand)) {
                    try {
                        consoleWriter.write("Sending diagnostics request... ");
                        consoleWriter.flush();
                        new DiagnosticsCommand(config).execute();
                        consoleWriter.write("OK\n");
                    }
                    catch (BadMacException badMacException) {
                        consoleWriter.write("MAC verification failed\n");
                    }
                    catch (IOException e) {
                        consoleWriter.write("Failed\n");
                        consoleWriter.append("Reason: ").append(e.getMessage()).append("\n");
                    }
                } else if ("2".equals(selectedCommand)) {
                    consoleWriter.append("Enter operator ID: ");
                    consoleWriter.flush();
                    operatorId = console.readLine();
                    consoleWriter.append("Enter table number (optional): ");
                    consoleWriter.flush();
                    tableNumber = console.readLine();
                    try {
                        consoleWriter.append("Sending open sales request...");
                        consoleWriter.flush();
                        List<OpenSale> openSales = new OpenSalesCommand(config, operatorId, tableNumber).execute();
                        consoleWriter.append("OK\n");
                        if (openSales.isEmpty()) {
                            consoleWriter.append("No open sales for operator ").append(operatorId);
                            if (StringUtils.isNotBlank((String)tableNumber)) {
                                consoleWriter.append(" on table ").append(tableNumber);
                            }
                            consoleWriter.append("\n");
                        } else {
                            consoleWriter.append("Open sales for operator ").append(operatorId);
                            if (StringUtils.isNotBlank((String)tableNumber)) {
                                consoleWriter.append(" on table ").append(tableNumber);
                            }
                            consoleWriter.append(":\n");
                            for (OpenSale openSale : openSales) {
                                consoleWriter.append("  - ").append(openSale.toString()).append("\n");
                            }
                        }
                    }
                    catch (UnsuccessfulRequestException e) {
                        if (e.getStatusCode() == 400) {
                            consoleWriter.append("Invalid table number\n");
                            break block65;
                        }
                        if (e.getStatusCode() == 401) {
                            consoleWriter.append("Invalid operator ID\n");
                            break block65;
                        }
                        if (e.getStatusCode() != 412) break block65;
                        if (e.getContent() == null) {
                            consoleWriter.append("Received 412 HTTP response (table is unavailable) with no optional content.\n");
                            break block65;
                        }
                        consoleWriter.append("Received 412 HTTP response (table is unavailable) with optional content.\n");
                        consoleWriter.append("Message is: " + e.getContent() + "\n");
                    }
                    catch (BadResponseContentException e) {
                        consoleWriter.append("Received invalid response from POS server:\n").append(e.getResponseContent()).append("\n");
                    }
                    catch (BadMacException badMacException) {
                        consoleWriter.append("MAC verification failed\n");
                    }
                    catch (AlwaysReturnOutcomeFlagException e) {
                        if (e.receivedFlag()) {
                            consoleWriter.append("Expected always-return-outcome in response from POS server to be true.").append("\n");
                            break block65;
                        }
                        consoleWriter.append("Expected always-return-outcome in response from POS server.").append("\n");
                    }
                    catch (Exception e) {
                        consoleWriter.append("Failed\n");
                        consoleWriter.append("Reason: ").append(e.getMessage()).append("\n");
                    }
                } else if ("3".equals(selectedCommand)) {
                    String amount;
                    String tableNumber2;
                    String posReference;
                    String operatorId2;
                    MobileIntegrationTerminalMessageSimulator.showTransactionActions(consoleWriter);
                    String transactionOption = console.readLine();
                    consoleWriter.println();
                    if ("1".equals(transactionOption)) {
                        consoleWriter.append("Enter operator ID: ");
                        consoleWriter.flush();
                        operatorId2 = console.readLine();
                        consoleWriter.append("Enter POS reference: ");
                        consoleWriter.flush();
                        posReference = console.readLine();
                        consoleWriter.append("Enter table number (optional): ");
                        consoleWriter.flush();
                        tableNumber2 = console.readLine();
                        amount = null;
                        while (amount == null) {
                            consoleWriter.append("Enter amount in dollars: ");
                            consoleWriter.flush();
                            try {
                                amount = MobileIntegrationTerminalMessageSimulator.parseAmount(console.readLine());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        String tipAmount = null;
                        while (tipAmount == null) {
                            consoleWriter.append("Enter tip in dollars (hit Enter for none): ");
                            consoleWriter.flush();
                            try {
                                tipAmount = MobileIntegrationTerminalMessageSimulator.parseTipAmount(console.readLine());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        try {
                            consoleWriter.append("Sending open sales request... ");
                            consoleWriter.flush();
                            List<OpenSale> openSales = new OpenSalesCommand(config, operatorId2, tableNumber2).execute();
                            boolean matchesPosReference = false;
                            for (OpenSale openSale : openSales) {
                                if (!posReference.equals(openSale.getPosReference())) continue;
                                matchesPosReference = true;
                                if (!tableNumber2.isEmpty()) break;
                                tableNumber2 = openSale.getTableNumber();
                                break;
                            }
                            if (!matchesPosReference) {
                                consoleWriter.append("\nFailed\n");
                                consoleWriter.append("Reason - ").append("Invalid or no open sales returned with POS reference: " + posReference);
                                if (!tableNumber2.isEmpty()) {
                                    consoleWriter.append(" and table number: " + tableNumber2);
                                }
                                consoleWriter.append("\n");
                                break block65;
                            }
                            consoleWriter.append("Posting transaction amount... ");
                            consoleWriter.flush();
                            new TransactionCommand(config, amount, tipAmount, posReference, tableNumber2, operatorId2, true, useValidMac).execute();
                            consoleWriter.append("OK\n");
                            consoleWriter.append(String.format("Posted transaction amount $%s to open sale %s%n", amount, posReference));
                        }
                        catch (UnsuccessfulRequestException e) {
                            consoleWriter.append(String.format("%nFailed%nServer returned status %s - %s%n", e.getStatusCode(), e.getStatusDescription()));
                        }
                        catch (UnexpectedResponseToBadMac e) {
                            MobileIntegrationTerminalMessageSimulator.failedDueToBadMac(consoleWriter, e);
                        }
                        catch (Exception e) {
                            consoleWriter.append("Failed\n");
                            consoleWriter.append("Reason: ").append(e.getMessage()).append("\n");
                        }
                    } else if ("2".equals(transactionOption)) {
                        consoleWriter.append("Enter operator ID: ");
                        consoleWriter.flush();
                        operatorId2 = console.readLine();
                        consoleWriter.append("Enter POS reference: ");
                        consoleWriter.flush();
                        posReference = console.readLine();
                        consoleWriter.append("Enter table number (optional): ");
                        consoleWriter.flush();
                        tableNumber2 = console.readLine();
                        amount = null;
                        while (amount == null) {
                            consoleWriter.append("Enter AUD amount in dollars: ");
                            consoleWriter.flush();
                            try {
                                amount = MobileIntegrationTerminalMessageSimulator.parseAmount(console.readLine());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {}
                        }
                        try {
                            consoleWriter.append("Sending open sales request... ");
                            consoleWriter.flush();
                            List<OpenSale> openSales = new OpenSalesCommand(config, operatorId2, tableNumber2).execute();
                            boolean matchesPosReference = false;
                            for (OpenSale openSale : openSales) {
                                if (!posReference.equals(openSale.getPosReference())) continue;
                                matchesPosReference = true;
                                if (!tableNumber2.isEmpty()) break;
                                tableNumber2 = openSale.getTableNumber();
                                break;
                            }
                            if (!matchesPosReference) {
                                consoleWriter.append("\nFailed\n");
                                consoleWriter.append("Reason - ").append("Invalid or no open sales returned with POS reference: " + posReference);
                                if (!tableNumber2.isEmpty()) {
                                    consoleWriter.append(" and table number: " + tableNumber2);
                                }
                                consoleWriter.append("\n");
                                break block65;
                            }
                            consoleWriter.append("Posting transaction amount... ");
                            consoleWriter.flush();
                            new DccTransactionCommand(config, amount, posReference, tableNumber2, operatorId2).execute();
                            consoleWriter.append("OK\n");
                            consoleWriter.append(String.format("Posted transaction amount $%s to open sale %s%n", amount, posReference));
                        }
                        catch (UnsuccessfulRequestException e) {
                            consoleWriter.append(String.format("Failed%nServer returned status %s - %s%n", e.getStatusCode(), e.getStatusDescription()));
                        }
                        catch (Exception e) {
                            consoleWriter.append("Failed\n");
                            consoleWriter.append("Reason: ").append(e.getMessage()).append("\n");
                        }
                    }
                } else if ("4".equals(selectedCommand)) {
                    consoleWriter.append("Enter operator ID: ");
                    consoleWriter.flush();
                    operatorId = console.readLine();
                    consoleWriter.append("Enter table number: ");
                    consoleWriter.flush();
                    tableNumber = console.readLine();
                    consoleWriter.append("Posting cancel ... ");
                    consoleWriter.flush();
                    try {
                        new TransactionCommand(config, null, null, null, tableNumber, operatorId, false, useValidMac).execute();
                        consoleWriter.append("OK\n");
                        consoleWriter.append(String.format("Posted cancel for operator %s and table %s", operatorId, tableNumber));
                    }
                    catch (UnsuccessfulRequestException e) {
                        consoleWriter.append(String.format("Failed%nServer returned status %s - %s%n", e.getStatusCode(), e.getStatusDescription()));
                    }
                    catch (UnexpectedResponseToBadMac e) {
                        MobileIntegrationTerminalMessageSimulator.failedDueToBadMac(consoleWriter, e);
                    }
                    catch (Exception e) {
                        consoleWriter.append("Failed\n");
                        consoleWriter.append("Reason: ").append(e.getMessage()).append("\n");
                    }
                } else if ("5".equals(selectedCommand)) {
                    useValidMac = false;
                    consoleWriter.append("Using invalid MAC header for all future Update Table requests. Expecting HTTP Status 403 for all future Update Table response\n");
                } else if ("6".equals(selectedCommand)) {
                    useValidMac = true;
                    consoleWriter.append("Using valid MAC header for all future requests\n");
                } else if ("7".equals(selectedCommand)) {
                    System.exit(0);
                } else {
                    consoleWriter.append("Invalid command\n");
                }
            }
            consoleWriter.flush();
            MobileIntegrationTerminalMessageSimulator.showActions(consoleWriter);
        }
    }

    private static void failedDueToBadMac(PrintWriter consoleWriter, UnexpectedResponseToBadMac e) {
        consoleWriter.append("Failed\n");
        consoleWriter.append("Expected server to reject this transaction with HTTP Status " + e.getExpectedResponseCode() + ", as an invalid MAC was used in the request, but received HTTP Status " + e.getActualResponseCode());
        consoleWriter.append("\n");
    }

    private static void readHttpBasicAuthCredentials(Configuration config, Properties props) {
        String username = props.getProperty("http.basic.username");
        String password = props.getProperty("http.basic.password");
        if (StringUtils.isNotBlank((String)username) && StringUtils.isNotBlank((String)password)) {
            config.setBasicAuthCredentials(username, password);
        }
    }

    private static Console getConsole() {
        java.io.Console console = System.console();
        if (console == null) {
            return new IntellijConsole();
        }
        return new JavaIoConsole(console);
    }

    private static void showIntroduction(PrintWriter consoleWriter) {
        String introduction = "--------------------------------------------------\n" + "Tyro Mobile Integration Terminal Message Simulator\n" + "--------------------------------------------------\n";
        consoleWriter.write(introduction);
        consoleWriter.flush();
    }

    private static void showActions(PrintWriter consoleWriter) {
        String commands = "\nAvailable actions:\n" + "  1 - Send diagnostics request\n" + "  2 - List open sales for operator\n" + "  3 - Post transaction amount to open sale\n" + "  4 - Post cancelled open sale request\n" + "  5 - Send invalid MAC for Update Table requests\n" + "  6 - Send valid MAC for all requests (default)\n" + "  7 - Exit simulator\n";
        consoleWriter.append(commands);
        consoleWriter.append("Enter action: ");
        consoleWriter.flush();
    }

    private static void showTransactionActions(PrintWriter consoleWriter) {
        String commands = "Available actions:\n" + "  1 - AUD transaction\n" + "  2 - USD transaction (using dynamic currency conversion feature)\n";
        consoleWriter.append(commands);
        consoleWriter.append("Enter action: ");
        consoleWriter.flush();
    }

    private static String parseTipAmount(String s) {
        if (StringUtils.isNotBlank((String)s)) {
            return MobileIntegrationTerminalMessageSimulator.parseAmount(s);
        }
        return "";
    }

    private static String parseAmount(String s) {
        if (!s.matches("\\$?\\d+(\\.\\d{2})?")) {
            throw new IllegalArgumentException();
        }
        String amount = s;
        if (amount.startsWith("$")) {
            amount = amount.substring(1);
        }
        if (!amount.contains(".")) {
            amount = String.valueOf(amount) + ".00";
        }
        return amount;
    }
}

