/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import java.math.BigDecimal;

public class OpenSale {
    private final String posReference;
    private final long amount;
    private final String tableNumber;
    private final String displayText;

    public OpenSale(String posReference, long amount, String tableNumber, String displayText) {
        this.posReference = posReference;
        this.amount = amount;
        this.tableNumber = tableNumber;
        this.displayText = displayText;
    }

    public String getPosReference() {
        return this.posReference;
    }

    public long getAmount() {
        return this.amount;
    }

    public String getAmountAsString() {
        return new BigDecimal(this.amount).divide(new BigDecimal("100")).setScale(2).toPlainString();
    }

    public String getTableNumber() {
        return this.tableNumber;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String toString() {
        return "POS reference: " + this.posReference + ", amount: $" + this.getAmountAsString() + ", display: " + this.displayText;
    }
}

