/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.moneyswitch.AlwaysReturnOutcomeFlagException;
import net.moneyswitch.BadMacException;
import net.moneyswitch.BadResponseContentException;
import net.moneyswitch.Configuration;
import net.moneyswitch.HttpContextFactory;
import net.moneyswitch.MacService;
import net.moneyswitch.OpenSale;
import net.moneyswitch.OpenSalesCommand$AjcClosure1;
import net.moneyswitch.RequestAndResponseLoggingAspect;
import net.moneyswitch.UnsuccessfulRequestException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenSalesCommand {
    private static final int MAX_LENGTH_OF_MESSAGE = 90;
    private final Configuration config;
    private final String operatorId;
    private final String tableNumber;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public OpenSalesCommand(Configuration config, String operatorId, String tableNumber) {
        this.config = config;
        this.operatorId = operatorId;
        this.tableNumber = tableNumber;
    }

    public List<OpenSale> execute() throws UnsuccessfulRequestException, BadMacException, BadResponseContentException, IOException, AlwaysReturnOutcomeFlagException {
        StringBuilder params = new StringBuilder();
        params.append("?operatorId=").append(this.operatorId);
        if (StringUtils.isNotBlank((String)this.tableNumber)) {
            params.append("&table=").append(this.tableNumber);
        }
        params.append("&mid=").append(this.config.getMid());
        params.append("&tid=").append(this.config.getTid());
        HttpGet request = new HttpGet(String.valueOf(this.config.getOpenSalesUrl()) + params.toString());
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpContext httpContext = HttpContextFactory.newContext(this.config);
        HttpGet httpGet = request;
        CloseableHttpClient closeableHttpClient = client;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)closeableHttpClient, (Object)httpGet, (Object)httpContext);
        Object[] objectArray = new Object[]{this, closeableHttpClient, httpGet, httpContext, joinPoint};
        HttpResponse response = RequestAndResponseLoggingAspect.aspectOf().logRequestsAndResponses(new OpenSalesCommand$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112), (HttpUriRequest)httpGet);
        StatusLine statusLine = response.getStatusLine();
        int statusCode = statusLine.getStatusCode();
        if (statusCode != 200) {
            String responseString;
            InputStream content;
            if (statusCode == 412 && (content = response.getEntity().getContent()).available() != 0 && StringUtils.isNotBlank((String)(responseString = IOUtils.toString(content)))) {
                if (responseString.length() > 90) {
                    responseString = responseString.substring(0, 90);
                }
                throw new UnsuccessfulRequestException(statusLine, responseString);
            }
            throw new UnsuccessfulRequestException(statusLine, null);
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            String json = EntityUtils.toString((HttpEntity)entity);
            Header macHeader = response.getFirstHeader("x-tyro-mac");
            String providedMac = macHeader.getValue();
            MacService.verifyMac(json, this.config, providedMac);
            ArrayList<OpenSale> openSales = new ArrayList<OpenSale>();
            try {
                JSONObject obj = new JSONObject(json);
                if (this.config.alwaysReturnOutcome()) {
                    if (obj.has("always-return-outcome")) {
                        String alwaysReturnOutcome = obj.getString("always-return-outcome");
                        if (!Boolean.parseBoolean(alwaysReturnOutcome)) {
                            throw new AlwaysReturnOutcomeFlagException(true);
                        }
                    } else {
                        throw new AlwaysReturnOutcomeFlagException(false);
                    }
                }
                JSONArray openSalesArray = obj.getJSONArray("open-sales");
                int i = 0;
                while (i < openSalesArray.length()) {
                    JSONObject openSaleObj = openSalesArray.getJSONObject(i);
                    OpenSale openSale = new OpenSale(openSaleObj.getString("pos-reference"), openSaleObj.getLong("amount"), openSaleObj.optString("table"), openSaleObj.optString("display-text"));
                    openSales.add(openSale);
                    ++i;
                }
            }
            catch (JSONException jSONException) {
                throw new BadResponseContentException(json);
            }
            return openSales;
        }
        return Collections.emptyList();
    }

    static {
        OpenSalesCommand.ajc$preClinit();
    }

    static final /* synthetic */ HttpResponse execute_aroundBody0(OpenSalesCommand openSalesCommand, HttpClient httpClient, HttpUriRequest httpUriRequest, HttpContext httpContext, JoinPoint joinPoint) {
        return httpClient.execute(httpUriRequest, httpContext);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OpenSalesCommand.java", OpenSalesCommand.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("601", "execute", "org.apache.http.client.HttpClient", "org.apache.http.client.methods.HttpUriRequest:org.apache.http.protocol.HttpContext", "arg0:arg1", "java.io.IOException:org.apache.http.client.ClientProtocolException", "org.apache.http.HttpResponse"), 51);
    }
}

