/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import java.math.BigDecimal;
import java.util.Random;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class ReceiptBlockBuilder {
    private final String tid;
    private final String elidedPan;
    private final String cardType;
    private final String baseAmount;
    private final String tipAmount;
    private final String transactionReference;
    private final DateTime terminalTransactionDateTime;
    private final String responseMessage;
    private final String responseCode;
    private final String tableNumber;
    private String amountInUSD;
    private String exchangeRate;

    public ReceiptBlockBuilder(String tid, String elidedPan, String cardType, String baseAmount, String tipAmount, String transactionReference, DateTime terminalTransactionDateTime, String responseMessage, String responseCode, String tableNumber) {
        this.tid = tid;
        this.elidedPan = elidedPan;
        this.cardType = cardType;
        this.baseAmount = baseAmount;
        this.tipAmount = tipAmount;
        this.transactionReference = transactionReference;
        this.terminalTransactionDateTime = terminalTransactionDateTime;
        this.responseMessage = responseMessage;
        this.responseCode = responseCode;
        this.tableNumber = tableNumber;
    }

    public ReceiptBlockBuilder withDccInfo(String amountInUSD, String exchangeRate) {
        this.amountInUSD = amountInUSD;
        this.exchangeRate = exchangeRate;
        return this;
    }

    public String build() {
        String responseTime = new BigDecimal(new Random().nextInt(500) + 1).divide(new BigDecimal(100)).toPlainString();
        String authorisationNumber = Integer.toString(new Random().nextInt(999999) + 1);
        StringBuilder receiptBlock = new StringBuilder().append("       Biro Payments        \n").append("      125 York Street       \n").append("      Sydney NSW 2000       \n").append("\n").append("       MERCHANT COPY        \n").append("\n").append("        Tyro EFTPOS         \n").append("\n").append("Card: ").append(this.elidedPan).append(" (s)\n").append(this.cardType).append("\n").append("\n").append(String.format("Purchase    AUD %11s%n", "$" + this.baseAmount));
        if (StringUtils.isNotBlank((String)this.tipAmount)) {
            receiptBlock.append(String.format("Tip         AUD %11s%n", "$" + this.tipAmount)).append("                 ----------\n").append(String.format("Total       AUD %11s%n", "$" + new BigDecimal(this.baseAmount).add(new BigDecimal(this.tipAmount)).toPlainString()));
        }
        receiptBlock.append("\n");
        if (this.amountInUSD != null && this.exchangeRate != null) {
            receiptBlock.append(StringUtils.center((String)"Transaction amount", (int)28)).append("\n").append(StringUtils.center((String)("USD " + this.amountInUSD), (int)28)).append("\n").append(StringUtils.center((String)"Exchange rate", (int)28)).append("\n").append(StringUtils.center((String)("1 AUD = " + this.exchangeRate + " USD"), (int)28)).append("\n").append("\n").append("With Dynamic currency       \n").append("conversion, I have been     \n").append("offered by the merchant a   \n").append("choice of currencies for    \n").append("payment, Australian Dollars \n").append("or my home currency. The    \n").append("payment in my home currency \n").append("at the point of sale is     \n").append("converted at the Pure       \n").append("Commerce provided wholesale \n").append("rate including a 2.5%       \n").append("mark-up.                    \n").append("\n");
        }
        receiptBlock.append(String.format("%-21s %s%n", this.responseMessage, this.responseCode)).append("\n").append("\n").append("\n").append("\n").append("___________________________\n").append("\n");
        if (this.tableNumber != null) {
            receiptBlock.append("Table number: ").append(this.tableNumber).append("\n");
        }
        receiptBlock.append("Terminal ID: ").append(this.tid).append("\n").append("Transaction Ref: ").append(this.transactionReference).append("\n").append("Authorisation No: ").append(authorisationNumber).append("\n").append(this.terminalTransactionDateTime.toString("dd MMM yyyy 'at' hh:mm a")).append("\n").append("\n").append("Please retain for your records\n").append("\n").append("Response time: ").append(responseTime).append(" sec\n");
        return receiptBlock.toString();
    }
}

