/*
 * Decompiled with CFR 0.152.
 */
package net.moneyswitch;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class RequestAndResponseLoggingAspect {
    private static final Log LOG = LogFactory.getLog((String)"RequestsAndResponses");
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ RequestAndResponseLoggingAspect ajc$perSingletonInstance;

    static {
        try {
            RequestAndResponseLoggingAspect.ajc$perSingletonInstance = new RequestAndResponseLoggingAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Around(value="call(org.apache.http.HttpResponse org.apache.http.client.HttpClient.execute(org.apache.http.client.methods.HttpUriRequest, ..)) && args(request, ..)")
    public HttpResponse logRequestsAndResponses(ProceedingJoinPoint pjp, HttpUriRequest request) throws Throwable {
        HttpEntity responseEntity;
        String responseContent;
        HttpPost postRequest;
        HttpEntity requestEntity;
        StringBuilder requestLog = new StringBuilder();
        requestLog.append("Request: ").append(request.getRequestLine());
        if (request.getFirstHeader("x-tyro-mac") != null) {
            requestLog.append("\n    ").append(request.getFirstHeader("x-tyro-mac"));
        }
        if (HttpPost.class.isAssignableFrom(request.getClass()) && (requestEntity = (postRequest = (HttpPost)request).getEntity()) != null) {
            requestLog.append("\n    ").append("request content: ").append(EntityUtils.toString((HttpEntity)requestEntity));
        }
        LOG.info((Object)requestLog.toString());
        HttpResponse response = (HttpResponse)pjp.proceed();
        StringBuilder responseLog = new StringBuilder();
        responseLog.append("Response: ").append(response.getStatusLine());
        if (response.getFirstHeader("x-tyro-mac") != null) {
            responseLog.append("\n    ").append(response.getFirstHeader("x-tyro-mac"));
        }
        if (StringUtils.isNotBlank((String)(responseContent = EntityUtils.toString((HttpEntity)(responseEntity = response.getEntity()))))) {
            responseLog.append("\n    ").append("response content: ").append(responseContent);
            response.setEntity((HttpEntity)new StringEntity(responseContent));
        }
        LOG.info((Object)responseLog.toString());
        return response;
    }

    public static RequestAndResponseLoggingAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("net.moneyswitch.RequestAndResponseLoggingAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

